define(["src/utils", "lodash"],
function(utils, lodash) {
	"use strict";
	
	function StageId(prefix) {	// prefix used for debugging
		var id = lodash.uniqueId(prefix);
		this.privateStageId = id;
		// closure is safer but complicates seeing the id when debugging
		// this.privateStageId = function () { return id.slice(0); };		
	}

	StageId.hash = function (self) {
		return self.getStageId();
	};
	
	utils.mixin(StageId, {
		getStageId : function () {
			return this.privateStageId.slice(0);
		}
	});
	
	return StageId;
});
